import React from 'react';

import {logError} from 'utilities/logger/logError';

interface IErrorBoundaryProps {
    renderError: () => React.ReactNode;
    handleError?: (error?: Error, errorInfo?: React.ErrorInfo) => void;
}

interface IErrorBoundaryState {
    hasError: boolean;
}

class ErrorBoundary extends React.Component<
    IErrorBoundaryProps,
    IErrorBoundaryState
> {
    readonly state: IErrorBoundaryState = {
        hasError: false,
    };

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void {
        const {handleError} = this.props;

        this.setState({hasError: true});

        if (handleError) {
            handleError(error, errorInfo);
        }

        try {
            logError(
                {
                    message: '[YATRAVEL] render error',
                    source: errorInfo.componentStack,
                },
                error,
            );
        } catch (e) {}
    }

    render(): React.ReactNode {
        if (this.state.hasError) {
            return this.props.renderError();
        }

        return this.props.children;
    }
}

export default ErrorBoundary;
