import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import nonceSelector from 'selectors/common/nonceSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {
    getFAQSchemaMarkup,
    IFAQSchemaMarkupItem,
} from 'components/SchemaMarkup/utilities/getFAQSchemaMarkup';

import SchemaMarkup from 'components/SchemaMarkup/SchemaMarkup';

import cx from './FAQ.scss';

interface IFAQProps extends IWithClassName, IWithQaAttributes {
    items: IFAQSchemaMarkupItem[];
}

const FAQ: React.FC<IFAQProps> = props => {
    const {className, items} = props;

    const nonce = useSelector(nonceSelector);

    return (
        <>
            {nonce && (
                <SchemaMarkup data={getFAQSchemaMarkup(items)} nonce={nonce} />
            )}

            <ol
                className={cx('FAQList', className)}
                {...prepareQaAttributes({
                    parent: props,
                    current: `list`,
                })}
            >
                {items.map(
                    (
                        {question, answer}: IFAQSchemaMarkupItem,
                        index: number,
                    ) => (
                        <li key={question} className={cx('FAQItem')}>
                            <h5
                                className={cx('FAQItemTitle')}
                                {...prepareQaAttributes({
                                    parent: props,
                                    current: 'faq-title',
                                    key: index,
                                })}
                            >
                                {question}
                            </h5>

                            <p
                                className={cx('FAQItemText')}
                                {...prepareQaAttributes({
                                    parent: props,
                                    current: 'faq-text',
                                    key: index,
                                })}
                            >
                                {answer}
                            </p>
                        </li>
                    ),
                )}
            </ol>
        </>
    );
};

export default React.memo(FAQ);
