import React from 'react';

import {EProjectName, INDEX_CROSSLINKS_MAX_COUNT} from 'constants/common';

import {ICrossLinkBlock} from 'server/api/CommonApi/types/CrossLinks';

import getCrossLinksUrl from 'utilities/url/getCrossLinksUrl';

import * as i18nBlock from 'i18nNew/buses-indexPage';

import FeaturedDirections from 'components/FeaturedDirections/FeaturedDirections';

interface IFeaturedDirectionsBlock {
    projectName: EProjectName;
    morePopularUrl?: string | undefined;
    crossLinks: ICrossLinkBlock[];
    blockClassName?: string;
}

const FeaturedDirectionsBlock: React.FC<IFeaturedDirectionsBlock> = ({
    projectName,
    morePopularUrl,
    crossLinks,
    blockClassName,
}) => {
    if (!crossLinks) {
        return null;
    }

    return (
        <>
            {crossLinks.map(({directions, title}, index) => (
                <FeaturedDirections
                    className={blockClassName}
                    key={index}
                    title={title}
                    morePopularUrl={morePopularUrl}
                    items={directions
                        .slice(0, INDEX_CROSSLINKS_MAX_COUNT)
                        .map(({from, to, minPrice}) => ({
                            url: getCrossLinksUrl({
                                type: projectName,
                                fromSlug: from?.slug,
                                toSlug: to.slug,
                            }),
                            text: from?.slug
                                ? i18nBlock.popularDashName({
                                      from: from?.linguistics.nominativeCase,
                                      to: to.linguistics.nominativeCase,
                                  })
                                : to.linguistics.nominativeCase,
                            price: minPrice
                                ? {
                                      currency: minPrice.currency,
                                      value: minPrice.value,
                                  }
                                : null,
                        }))}
                />
            ))}
        </>
    );
};

export default React.memo(FeaturedDirectionsBlock);
