import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text, {TextColor} from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './FieldLabel.scss';

interface IFieldProps extends IWithClassName, IWithQaAttributes {
    label: string;
    labelColor?: TextColor;
    children: React.ReactNode;
}

const FieldLabel: React.FC<IFieldProps> = props => {
    const {className, label, labelColor = 'secondary', children} = props;

    return (
        <Flex
            className={className}
            flexDirection="column"
            {...prepareQaAttributes(props)}
        >
            <Text
                size="s"
                color={labelColor}
                {...prepareQaAttributes({parent: props, current: 'label'})}
            >
                {label}
            </Text>
            <Text
                className={cx('value')}
                size="m"
                {...prepareQaAttributes({parent: props, current: 'value'})}
            >
                {children}
            </Text>
        </Flex>
    );
};

export default FieldLabel;
