import React from 'react';

import typedReactMemo from 'types/typedReactMemo';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/avia-search';
import * as i18nCommonFiltersBlock from 'i18nNew/common-filters';

import Separator from 'components/Separator/Separator';
import Button from 'components/Button/Button';
import Box from 'components/Box/Box';
import {IFiltersAndSortsMobileProps} from 'components/FiltersAndSortsMobile/FiltersAndSortsMobile';

import cx from './ModalContent.scss';

interface IModalContentProps
    extends IWithQaAttributes,
        Omit<IFiltersAndSortsMobileProps, 'activeFiltersCount' | 'isCompact'> {}

const ModalContent = (props: IModalContentProps): React.ReactElement => {
    const {itemsCount, children, canReset, onReset, onApply} = props;

    return (
        <>
            <Separator className={cx('separator')} />

            <div className={cx('content')}>{children}</div>

            <Box between="2" inline nowrap x="4" y="5" className={cx('footer')}>
                <Button
                    width="max"
                    onClick={onReset}
                    disabled={!canReset}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'resetButton',
                    })}
                >
                    {i18nCommonFiltersBlock.reset()}
                </Button>

                <Button
                    width="max"
                    theme="primary"
                    onClick={onApply}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'applyButton',
                    })}
                >
                    {i18nBlock.filtersDotApply({
                        count: itemsCount,
                    })}
                </Button>
            </Box>
        </>
    );
};

export default typedReactMemo(ModalContent);
