import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/common-filters';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Button from 'components/Button/Button';
import FiltersDesktopSkeleton from 'components/FiltersDesktop/components/FilterDesktopSkeleton/FiltersDesktopSkeleton';

import cx from './FiltersDesktop.scss';

export interface IFiltersDesktopProps
    extends IWithClassName,
        IWithQaAttributes {
    loading?: boolean;
    skeletonsWidth: number[];
    children: React.ReactNode;
    rightNode?: React.ReactNode;
    canReset: boolean;
    onReset?: () => void;
}

const FiltersDesktop: React.FC<IFiltersDesktopProps> = ({
    className,
    loading = false,
    skeletonsWidth,
    canReset,
    children,
    rightNode,
    onReset,
    ...rest
}) => {
    return (
        <div className={cx('root')}>
            <Box
                className={cx('wrapper')}
                between={2}
                y={3}
                inline
                nowrap
                {...prepareQaAttributes(rest)}
            >
                <Flex
                    className={cx('items', {items_loading: loading}, className)}
                    inline
                    flexWrap="wrap"
                >
                    {loading ? (
                        <FiltersDesktopSkeleton
                            skeletonsWidth={skeletonsWidth}
                        />
                    ) : (
                        <>
                            {children}
                            {canReset && (
                                <Button
                                    theme="attention"
                                    onClick={onReset}
                                    {...prepareQaAttributes({
                                        parent: rest,
                                        current: 'reset',
                                    })}
                                >
                                    {i18nBlock.reset()}
                                </Button>
                            )}
                        </>
                    )}
                </Flex>

                {rightNode}
            </Box>
        </div>
    );
};

export default React.memo(FiltersDesktop);
