import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import 'svgxuse';
import countries from './images/countries.svg';

interface IFlagIconProps extends IWithClassName {
    width?: number;
    height?: number;
    country: string;
}

const FlagIcon: FunctionComponent<IFlagIconProps> = ({
    className,
    width,
    height,
    country,
}) => (
    <svg
        className={className}
        xmlnsXlink="http://www.w3.org/1999/xlink"
        viewBox="0 0 16 12"
        width={width}
        height={height}
    >
        <use xlinkHref={`${countries}#${country}`} />
    </svg>
);

FlagIcon.defaultProps = {
    width: 16,
    height: 12,
};

export default FlagIcon;
