import React from 'react';

import Box, {IBoxProps} from 'components/Box/Box';

import cx from './Flex.scss';

export interface IFlexProps extends IBoxProps {
    justifyContent?: React.CSSProperties['justifyContent'];
    alignItems?: React.CSSProperties['alignItems'];
    flexDirection?: React.CSSProperties['flexDirection'];
    flexWrap?: React.CSSProperties['flexWrap'];
}

const Flex: React.FC<IFlexProps> = React.forwardRef<HTMLElement, IFlexProps>(
    (
        {
            justifyContent,
            alignItems,
            flexDirection,
            flexWrap,
            className,
            ...props
        },
        ref,
    ) => (
        <Box
            className={cx(
                'root',
                className,
                justifyContent && `justifyContent_${justifyContent}`,
                alignItems && `alignItems_${alignItems}`,
                flexDirection && `flexDirection_${flexDirection}`,
                flexWrap && `flexWrap_${flexWrap}`,
            )}
            ref={ref}
            {...props}
        />
    ),
);

Flex.displayName = 'Flex';

export default Flex;
