import React from 'react';

import {EFooterProject, IFooterCommonProps} from 'components/Footer/types';
import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {getPhoneUrl} from 'utilities/url/getPhoneUrl';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18nNew/components';

import {useSupportPhone} from 'hooks/useSupportPhone';

import Container from 'components/Layouts/Container/Container';
import OrderFooter from 'components/Footer/components/OrderFooter/OrderFooter';
import IndexFooter from 'components/Footer/components/IndexFooter/IndexFooter';
import Flex from 'components/Flex/Flex';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import CallIcon from 'icons/16/Call';

import cx from './Footer.scss';

const ROOT_QA = 'portalFooter';

interface IFooterProps extends IFooterCommonProps, IWithClassName {
    /**
     * Специальный тип футера для главных и поисковых страниц
     */
    isIndex?: boolean;
    wrapperClassName?: string;
}

const Footer: React.FC<IFooterProps> = props => {
    const {
        className,
        wrapperClassName,
        footerType,
        project,
        isIndex = false,
    } = props;

    const phone = useSupportPhone();
    const {isMobile} = useDeviceType();

    const FooterComponent = isIndex ? IndexFooter : OrderFooter;

    const supportBlock = isMobile && footerType === EFooterProject.TRIPS && (
        <Flex
            className={cx('supportBlock')}
            justifyContent="space-between"
            alignItems="center"
        >
            <Flex
                flexDirection="column"
                {...prepareQaAttributes({
                    parent: ROOT_QA,
                    current: 'supportPhone',
                })}
            >
                <span>{i18nBlock.footerSupportTitle()}</span>

                <span className={cx('phone')}>{phone}</span>
            </Flex>

            <ButtonLink
                url={getPhoneUrl(phone)}
                size="l"
                shape="circle"
                {...prepareQaAttributes({
                    parent: ROOT_QA,
                    current: 'supportPhoneButton',
                })}
            >
                <CallIcon />
            </ButtonLink>
        </Flex>
    );

    return (
        <footer className={className} {...prepareQaAttributes(ROOT_QA)}>
            <Container className={wrapperClassName}>
                {supportBlock}

                <div className={cx('footer')}>
                    <FooterComponent
                        project={project}
                        footerType={footerType}
                    />
                </div>
            </Container>
        </footer>
    );
};

export default React.memo(Footer);
