import React from 'react';

import * as AVIA_APPS_LINKS from 'components/Footer/constants/aviaAppsLinks';
import {IOS, Android} from 'utilities/deviceType/constants';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isOS} from 'utilities/deviceType/isOS';

import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import AppleStoreIcon from 'icons/illustrations/Stores/StoresStore-ios-ru';
import GooglePlayIcon from 'icons/illustrations/Stores/StoresStore-android-ru';

interface IAppLinks extends IWithClassName {}

const AppLinks: React.FC<IAppLinks> = props => {
    const {className} = props;
    const {os} = useDeviceType();

    const isIOS = isOS(os, IOS);
    const isAndroid = isOS(os, Android);

    return (
        <Flex className={className} inline nowrap between={2}>
            {!isIOS && (
                <Link
                    url={AVIA_APPS_LINKS.googlePlay}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <GooglePlayIcon width={108} height={32} />
                </Link>
            )}

            {!isAndroid && (
                <Link
                    url={AVIA_APPS_LINKS.appleStore}
                    target="_blank"
                    rel="noopener noreferrer"
                >
                    <AppleStoreIcon width={108} height={32} />
                </Link>
            )}
        </Flex>
    );
};

export default AppLinks;
