import React from 'react';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IFooterBlockProps {
    title: string;
    children: React.ReactElement;
}

const FooterBlock: React.FC<IFooterBlockProps> = props => {
    const {title, children} = props;

    return (
        <Flex flexDirection={'column'} between={3}>
            <Text size={'s'} weight={'bold'}>
                {title}
            </Text>
            {children}
        </Flex>
    );
};

export default FooterBlock;
