import React from 'react';

import {YANDEX_ROOT_PATH} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18nNew/common-footer';

import Link from 'components/Link/Link';
import Copyright from 'components/Copyright/Copyright';

import cx from './FooterCopyright.scss';

interface IFooterCopyrightProps extends IWithClassName {}

const FooterCopyright: React.FC<IFooterCopyrightProps> = props => {
    const {className} = props;

    return (
        <Copyright start={2009} className={cx(className, 'root')}>
            <Link className={cx('link')} url={YANDEX_ROOT_PATH} theme="normal">
                {i18nBlock.companyDashName()}
            </Link>
        </Copyright>
    );
};

export default FooterCopyright;
