import React from 'react';

import getMenuItems from 'components/Footer/constants/footerMenuItems';
import {EProjectName} from 'constants/common';

import {IFooterCommonProps} from 'components/Footer/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18nNew/components';

import Box from 'components/Box/Box';
import SupportPhone from 'components/SupportPhone/SupportPhone';
import FooterLinks from 'components/Footer/components/FooterLinks/FooterLinks';
import FooterCopyright from 'components/Footer/components/FooterCopyright/FooterCopyright';
import AppLinks from 'components/Footer/components/AppLinks/AppLinks';
import Text from 'components/Text/Text';
import SocialLinks from 'components/Footer/components/SocialLinks/SocialLinks';
import Flex from 'components/Flex/Flex';

import cx from './OrderFooter.scss';

const OrderFooter: React.FC<IFooterCommonProps> = props => {
    const {footerType, project} = props;

    const deviceType = useDeviceType();

    const menu = getMenuItems({footerType});

    const phoneBlock =
        project === EProjectName.BUSES ? (
            <Box textSize="s">
                {insertJSXIntoKey(i18nBlock.footerDotSupport)({
                    phone: <SupportPhone className={cx('phone')} />,
                })}
            </Box>
        ) : null;

    const linksBlock = <FooterLinks type={'horizontal'} links={menu} />;

    const copyrightBlock = <FooterCopyright />;

    const aviaAppsBlock = project === EProjectName.AVIA ? <AppLinks /> : null;

    const socialBlock = (
        <Flex flexDirection={'column'} between={1}>
            <Text size="s">{i18nBlock.footerDotSocials()}</Text>

            <SocialLinks />
        </Flex>
    );

    if (deviceType.isMobile) {
        return (
            <Flex flexDirection={'column'} between={6}>
                {phoneBlock}
                <Flex flexDirection={'column'} between={5}>
                    <Flex flexDirection={'column'} between={7}>
                        {linksBlock}
                        {aviaAppsBlock}
                    </Flex>

                    <Flex flexDirection={'column'} between={5}>
                        {socialBlock}
                        {copyrightBlock}
                    </Flex>
                </Flex>
            </Flex>
        );
    }

    return (
        <Flex justifyContent="space-between">
            <Flex flexDirection={'column'} between={3}>
                {linksBlock}
                {socialBlock}
            </Flex>

            <Flex
                flexDirection="column"
                alignItems="flex-end"
                between={aviaAppsBlock ? 8 : 3}
            >
                {phoneBlock}
                {copyrightBlock}
                {aviaAppsBlock}
            </Flex>
        </Flex>
    );
};

export default OrderFooter;
