import React from 'react';

import Link from 'components/Link/Link';
import DzenIcon from 'icons/stores/DzenIcon';
import VKIcon from 'icons/stores/VKIcon';
import InstagramIcon from 'icons/stores/InstagramIcon';
import TelegramIcon from 'icons/stores/TelegramIcon';
import Flex from 'components/Flex/Flex';

const SocialLinks: React.FC = () => {
    return (
        <Flex inline between={2}>
            <Link
                url="https://zen.yandex.ru/yandextravel"
                target="_blank"
                rel="noopener noreferrer"
            >
                <DzenIcon />
            </Link>

            <Link
                url="https://vk.com/travel.yandex"
                target="_blank"
                rel="noopener noreferrer"
            >
                <VKIcon />
            </Link>

            <Link
                url="https://www.instagram.com/yandex.travel/"
                target="_blank"
                rel="noopener noreferrer"
            >
                <InstagramIcon />
            </Link>

            <Link
                url="https://t.me/yandex_travel"
                target="_blank"
                rel="noopener noreferrer"
            >
                <TelegramIcon />
            </Link>
        </Flex>
    );
};

export default SocialLinks;
