import {EProjectName} from 'constants/common';
import {
    HOTELS_BOOKING_CONDITIONS_LINK,
    TRAINS_CONDITIONS_LINK,
    COMMON_PARTNERS_LINK,
    COMMON_AFFILIATES_LINK,
    BUSES_BOOKING_CONDITIONS_LINK,
    HOTELS_TAXI_CONDITIONS_LINK,
    HOTELS_NEW_OBJECT_LINK,
    COMMON_HELP_LINK,
    COMMON_AGREEMENT_LINK,
    COMMON_PRODUCTS_LINK,
    COMMON_FEEDBACK_LINK,
    COMMON_PLUS_LEGAL,
    COMMON_PLUS_LOYALTY,
} from 'components/Footer/constants/footerLinks';

import {IFooterLink, EFooterProject} from 'components/Footer/types';

export const PROJECT_FOOTER_TYPES: PartialRecord<EProjectName, EFooterProject> =
    {
        [EProjectName.ACCOUNT]: EFooterProject.ACCOUNT,
        [EProjectName.AVIA]: EFooterProject.AVIA,
        [EProjectName.TRAINS]: EFooterProject.TRAINS,
        [EProjectName.HOTELS]: EFooterProject.HOTELS,
        [EProjectName.BUSES]: EFooterProject.BUSES,
    };

const FOOTER_MENU_ITEMS: Record<EFooterProject, IFooterLink[]> = {
    [EFooterProject.AVIA]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_PRODUCTS_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.TRAINS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        TRAINS_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_PRODUCTS_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.HOTELS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        HOTELS_NEW_OBJECT_LINK,
        HOTELS_TAXI_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_PRODUCTS_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.HOTELS_BOOKING]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        HOTELS_NEW_OBJECT_LINK,
        HOTELS_BOOKING_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.ACCOUNT]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.ACCOUNT_TRAINS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        TRAINS_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.BUSES]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        BUSES_BOOKING_CONDITIONS_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_PRODUCTS_LINK,
        COMMON_AGREEMENT_LINK,
    ],
    [EFooterProject.TRIPS]: [
        COMMON_PARTNERS_LINK,
        COMMON_AFFILIATES_LINK,
        COMMON_HELP_LINK,
        COMMON_FEEDBACK_LINK,
        COMMON_AGREEMENT_LINK,
    ],
};

const DEFAULT_FOOTER_MENU_ITEMS = [
    COMMON_HELP_LINK,
    COMMON_FEEDBACK_LINK,
    COMMON_AGREEMENT_LINK,
];

export default function getMenuItems(props: {
    footerType: EFooterProject | undefined;
}): IFooterLink[] {
    const plusItems = [COMMON_PLUS_LEGAL, COMMON_PLUS_LOYALTY];

    if (!props.footerType) {
        return DEFAULT_FOOTER_MENU_ITEMS.concat(plusItems);
    }

    return (
        FOOTER_MENU_ITEMS[props.footerType] ?? DEFAULT_FOOTER_MENU_ITEMS
    ).concat(plusItems);
}
