import {FunctionComponent, ReactNode} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {getUserInfo} from 'selectors/common/userInfoSelector';

import {EPassportMode, getPassportUrl} from 'utilities/url/getPassportUrl';
import getCommonCardProps from 'projects/depreacted/hotels/components/ForceLogin/utilities/getCommonCardProps';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Card from 'components/Card/Card';
import TouchLogoYaSign from 'icons/illustrations/Touch/TouchLogoYaSign';
import ArrowRightIcon from 'icons/16/ArrowRight';
import Link from 'components/Link/Link';
import ForceLoginLayout from 'components/ForceLogin/ForceLoginLayout/ForceLoginLayout';

import cx from './ForceLoginAuthLink.scss';

interface IForceLoginAuthLinkProps extends IWithClassName {
    message: ReactNode;
}

const ForceLoginAuthLink: FunctionComponent<IForceLoginAuthLinkProps> = ({
    className,
    message,
}) => {
    const {passportPath} = useSelector(getUserInfo);
    const {isMobile} = useDeviceType();

    return (
        <Card className={className} {...getCommonCardProps(isMobile)}>
            <Link
                url={getPassportUrl({
                    mode: EPassportMode.AUTH,
                    passportHost: passportPath,
                    retpath: window.location.href,
                })}
            >
                <ForceLoginLayout
                    image={<TouchLogoYaSign className={cx('logo')} />}
                    imageClassName={cx('logoWrap')}
                    text={message}
                    icon={ArrowRightIcon}
                    hoverType="entire"
                />
            </Link>
        </Card>
    );
};

export default ForceLoginAuthLink;
