import {FunctionComponent, ReactNode} from 'react';
import {
    Field as FinalField,
    FieldProps,
    FieldRenderProps,
} from 'react-final-form';

import joinGroupIds from 'components/Form/utilities/joinGroupIds';

import {FieldGroupContext} from 'components/Form/components/FieldGroup/FieldGroup';

export interface IFieldProps<T = any>
    extends FieldProps<T, FieldRenderProps<T, HTMLElement>> {}

const Field: FunctionComponent<IFieldProps> = ({
    name,
    allowNull = true,
    initialValue = null,
    // Дефолтное значение необходимо для того, чтобы для незаполненых полей (значение пустая строка),
    // значение поля в состонии формы не удалялось: https://final-form.org/docs/react-final-form/types/FieldProps#parse
    // Это позволяет сохранять структуру данных в форме, даже если во всех полях пустые значения.
    parse = (value: unknown): unknown => value,
    ...props
}) => {
    return (
        <FieldGroupContext.Consumer>
            {(groupId?: string): ReactNode => (
                <FinalField
                    name={joinGroupIds(groupId, name)}
                    allowNull={allowNull}
                    initialValue={initialValue}
                    parse={parse}
                    {...props}
                />
            )}
        </FieldGroupContext.Consumer>
    );
};

export default Field;
