import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import FieldGroup, {FieldGroupContext} from './FieldGroup';

export default {
    title: 'Example/FieldGroup',
    component: FieldGroup,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <FieldGroup groupId="passenger">
        <FieldGroupContext.Consumer>
            {(groupId): ReactNode => <div>GroupId: {groupId}</div>}
        </FieldGroupContext.Consumer>
    </FieldGroup>
);

export const WithIndex: TStorybookFunctionComponent = () => (
    <FieldGroup groupId="passenger">
        <FieldGroup groupId="adult">
            <FieldGroup groupId="0">
                <FieldGroupContext.Consumer>
                    {groupId => <div>GroupId: {groupId}</div>}
                </FieldGroupContext.Consumer>
            </FieldGroup>
        </FieldGroup>
    </FieldGroup>
);
