import React, {FunctionComponent} from 'react';

import joinGroupIds from 'components/Form/utilities/joinGroupIds';

export const FieldGroupContext = React.createContext<string>('');

interface IFieldGroupProps {
    children: React.ReactNode;
    groupId: string | number;
}

const FieldGroup: FunctionComponent<IFieldGroupProps> = ({
    groupId,
    children,
}) => {
    return (
        <FieldGroupContext.Consumer>
            {(parentGroupId): React.ReactNode => (
                <FieldGroupContext.Provider
                    value={joinGroupIds(parentGroupId, groupId)}
                >
                    {children}
                </FieldGroupContext.Provider>
            )}
        </FieldGroupContext.Consumer>
    );
};

export default FieldGroup;
