import {useField} from 'react-final-form';

/**
 * Возвращает значение поля формы.
 *
 * В отличие от хука useFieldValue форсит ререндер только при изменении
 * определенной части формы, а не при любом изменении
 */
export default function useMemoFormFieldValue<Value>(name: string): Value {
    const {
        input: {value},
    } = useField(name, {
        subscription: {value: true},
    });

    return value;
}
