import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import GoToForm from './GoToForm';

export default {
    title: 'Example/GoToForm',
    component: GoToForm,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <ul>
            {Array.from(Array(100).keys()).map(i => (
                <li key={i}>{i}</li>
            ))}
        </ul>
        <GoToForm active={true} getBorderTopToHidden={(): number => 1000}>
            <Button>Поскроль вниз</Button>
        </GoToForm>
    </>
);
Simple.parameters = {
    info: {
        title: 'Форма, которая показывается пока основная форма не видна из-за скрола',
        comment: 'Пример использования, форма скрывается после 1000px',
    },
};
