import {useCallback, useEffect, useRef, useState} from 'react';

const THRESHOLD = 20;
const VISIBLE_AREA = 200;

export function useScrollHiding(): boolean {
    const [isHidden, setHidden] = useState(false);
    const lastScrollY = useRef(0);

    const handleScroll = useCallback(() => {
        if (window.scrollY < VISIBLE_AREA) {
            setHidden(false);

            return;
        }

        const diff = lastScrollY.current - window.scrollY;

        if (diff > THRESHOLD) {
            lastScrollY.current = window.scrollY;
            setHidden(false);
        } else if (diff < -THRESHOLD) {
            lastScrollY.current = window.scrollY;
            setHidden(true);
        }
    }, [setHidden]);

    useEffect(() => {
        lastScrollY.current = window.scrollY;
        window.addEventListener('scroll', handleScroll);

        return (): void => {
            window.removeEventListener('scroll', handleScroll);
        };
    }, [handleScroll]);

    return isHidden;
}
