import {FunctionComponent, useCallback} from 'react';

import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';

import {internalUrl} from 'utilities/url';
import {params} from 'utilities/metrika';

import GiftOutlineIcon from 'icons/24/GiftOutline';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

import cx from './CertificateLink.scss';

interface ICertificateIconProps extends IWithClassName {
    title?: string;
    label?: string;
}

const CertificateLink: FunctionComponent<ICertificateIconProps> = ({
    className,
    title,
    label,
}) => {
    const handleClick = useCallback(() => {
        params({common: {headerCertificateClick: true}});
    }, []);

    return (
        <Link
            className={className}
            theme="black"
            to={internalUrl(URLs.promoCertificatesUrl)}
            title={title}
            target="_blank"
            rel="noopener noreferrer"
            onClick={handleClick}
        >
            <Flex inline alignItems="center" between={2}>
                <span className={cx('icon')}>
                    <GiftOutlineIcon />
                    <div className={cx('gradient')} />
                </span>

                {label && (
                    <Text className={cx('text')} color="current" size="s">
                        {label}
                    </Text>
                )}
            </Flex>
        </Link>
    );
};

export default CertificateLink;
