import {useState, useCallback} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import Input from 'components/Input/Input';
import Select from 'components/Select/Select';
import RadioButton from 'components/RadioButton/RadioButton';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import WarningIcon from 'icons/12/Warning';

import Hint from './Hint';

export default {
    title: 'Example/Hint',
    component: Hint,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Hint message="Подсказка к полю">
        <Input name="one" />
    </Hint>
);

export const Error: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('');
    const [hasError, setError] = useState(false);

    const handleChange = useCallback((_, newValue) => {
        setValue(newValue);
        setError(newValue.length > 5);
    }, []);

    return (
        <Hint
            message={
                hasError ? 'А ты бунтарь ;-)' : 'Введи не больше 5 символов'
            }
            isError={hasError}
        >
            <Input
                value={value}
                name="one"
                placeholder="Нажми сюда"
                state={hasError ? 'error' : undefined}
                onChange={handleChange}
            />
        </Hint>
    );
};

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            's' as const,
            'm' as const,
            'm-inset' as const,
            'l' as const,
            'xl' as const,
        ].map(size => ({
            name: size,
            example: (
                <Hint size={size} message="Подсказка">
                    <RadioButton
                        name="gender"
                        size={size}
                        width="max"
                        onChange={noop}
                    >
                        <RadioButton.Radio value="male">М</RadioButton.Radio>
                        <RadioButton.Radio value="female">Ж</RadioButton.Radio>
                    </RadioButton>
                </Hint>
            ),
        }))}
    />
);

export const WithIcon: TStorybookFunctionComponent = () => (
    <Hint
        message={
            <span>
                <WarningIcon />
                <span> Текст с иконкой</span>
            </span>
        }
    >
        <Select
            size="m"
            theme="outlined"
            value="a"
            options={[
                {value: 'a', data: 'Каждый'},
                {value: 'b', data: 'Охотник'},
            ]}
            placeholder="—"
            onChange={noop}
        />
    </Hint>
);
