import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './HorizontalHiddenScroll.scss';

interface IHorizontalHiddenScrollProps
    extends IWithClassName,
        IWithQaAttributes,
        React.HTMLAttributes<HTMLDivElement> {
    scrollableClassName?: string;
    scrollerRef?: React.RefObject<HTMLDivElement>;
}

const HorizontalHiddenScroll: React.FC<IHorizontalHiddenScrollProps> =
    props => {
        const {className, children, scrollableClassName, scrollerRef, ...rest} =
            props;

        return (
            <div
                className={cx('root', className)}
                {...rest}
                {...prepareQaAttributes(props)}
            >
                <div
                    className={cx('scrollable', scrollableClassName)}
                    ref={scrollerRef}
                >
                    {children}
                </div>
            </div>
        );
    };

export default HorizontalHiddenScroll;
