import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import HorizontalScroller from './HorizontalScroller';

import './__docs__/styles.scss';

export default {
    title: 'Example/HorizontalScroller',
    component: HorizontalScroller,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div className="container">
        <HorizontalScroller offset="5">
            <div className="item">1</div>
            <div className="item">2</div>
            <div className="item">3</div>
            <div className="item">4</div>
            <div className="item">5</div>
            <div className="item">6</div>
        </HorizontalScroller>
    </div>
);
Simple.parameters = {
    info: {
        comment:
            'Компонент со скрытым горизонтальным скролом и боковыми отступами для тача. Не игнорирует конечный отступ справа у контейнера.',
    },
};
