import React, {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './Icon.scss';

interface IIconProps extends IWithClassName, IWithQaAttributes {
    children: React.ReactNode;
}

export const Icon: FunctionComponent<IIconProps> = ({
    className,
    children,
    ...rest
}) => {
    return (
        <i className={cx('icon', className)} {...prepareQaAttributes(rest)}>
            {children}
        </i>
    );
};

export default Icon;
