import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import HotelIcon from 'icons/16/Hotel';
import Text from 'components/Text/Text';

import IconWithRoundBackground from './IconWithRoundBackground';

export default {
    title: 'Example/IconWithRoundBackground',
    component: IconWithRoundBackground,
} as Meta;

export const Example: TStorybookFunctionComponent = () => (
    <Box between={2}>
        <Text size="m">
            В примере голубой, но можно задать любой цвет и любую иконку
        </Text>
        <IconWithRoundBackground
            icon={<HotelIcon color="#fff" />}
            backgroundColor="label-secondary"
        />
    </Box>
);
