import React, {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import Icon from 'components/Icon/Icon';

import cx from './IconWithRoundBackground.scss';

interface IIconWithRoundBackgroundProps extends IWithClassName {
    icon: React.ReactElement;
    backgroundColor: 'label-secondary' | 'control-secondary' | 'primary';
    size?: '32' | '36';
}

export const IconWithRoundBackground: FunctionComponent<IIconWithRoundBackgroundProps> =
    ({icon, backgroundColor, size = '32', className}) => {
        return (
            <div
                className={cx('background', className, {
                    [`background_color_${backgroundColor}`]: backgroundColor,
                    [`background_size_${size}`]: size,
                })}
            >
                <Icon>{icon}</Icon>
            </div>
        );
    };

export default IconWithRoundBackground;
