import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './ImageIcon.scss';

interface IImageIconProps extends IWithClassName {
    src: string;
    width?: number;
    height?: number;
    alt?: string;
}

const ImageIcon: FunctionComponent<IImageIconProps> = ({
    src,
    alt,
    className,
    height,
    width,
}) => {
    return (
        <img
            src={src}
            alt={alt}
            className={cx('root', className)}
            style={{width, height}}
        />
    );
};

export default ImageIcon;
