import React, {useCallback, useState} from 'react';
import {Meta} from '@storybook/react';

import {TImagesSelectorImage} from './types/IImagesSelectorImage';

import Box from 'components/Box/Box';

import ImagesSelector from './ImagesSelector';

export default {
    title: 'Example/ImagesSelector',
    component: ImagesSelector,
} as Meta;

export const Common: React.FC = () => {
    const [images, setImages] = useState<TImagesSelectorImage[]>([]);

    const handleImagesSelected = useCallback(
        newImages => {
            setImages([...images, ...newImages]);
        },
        [images, setImages],
    );

    const handleDeleteClick = useCallback(
        imageToDelete => {
            setImages(images.filter(i => i !== imageToDelete));
        },
        [images, setImages],
    );

    return (
        <Box style={{backgroundColor: 'white', padding: '20px'}}>
            <ImagesSelector
                images={images}
                onImagesSelected={handleImagesSelected}
                onDeleteClick={handleDeleteClick}
            />
        </Box>
    );
};
