import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18nNew/hotels-HotelReviews';

import CameraIcon from 'icons/36/Camera';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './SelectImageTrigger.scss';

interface ISelectImageTriggerProps {
    onClick: () => void;
    isWide: boolean;
}

const SelectImageTrigger: React.FC<ISelectImageTriggerProps> = ({
    onClick,
    isWide,
}) => {
    const deviceType = useDeviceType();

    return (
        <Flex
            flexDirection="column"
            alignItems="center"
            justifyContent="center"
            onClick={onClick}
            className={cx('root', deviceMods('root', deviceType), {
                root_wide: isWide,
            })}
        >
            <CameraIcon className={cx('icon')} />
            {isWide && (
                <Text size="m" className={cx('text')}>
                    {i18nBlock.addPhotos()}
                </Text>
            )}
        </Flex>
    );
};

export default SelectImageTrigger;
