import React, {useMemo} from 'react';

import {getContainerOffset} from '../utilities/animationHepers';

import Flex from 'components/Flex/Flex';

import cx from './NavigationAnimationController.scss';

export interface INavigationAnimationControllerProps {
    itemsCount: number;
    activeItem: number;
    maxItemsCount: number;
    pointsSize: number;
}

const NavigationAnimationController: React.FC<INavigationAnimationControllerProps> =
    ({itemsCount, maxItemsCount, pointsSize, activeItem, children}) => {
        const offset = useMemo(
            () =>
                getContainerOffset(
                    itemsCount,
                    maxItemsCount,
                    pointsSize,
                    activeItem,
                ) * -1,
            [itemsCount, maxItemsCount, activeItem, pointsSize],
        );

        const maxWidth = maxItemsCount * pointsSize;
        const transform = `translate3d(${offset}px, 0, 0)`;

        return (
            <Flex className={cx('crop')} style={{maxWidth: `${maxWidth}px`}}>
                <Flex
                    alignItems="center"
                    justifyContent="center"
                    className={cx('items')}
                    style={{transform}}
                >
                    {children}
                </Flex>
            </Flex>
        );
    };

export default NavigationAnimationController;
