import {FunctionComponent, useEffect, useState, ReactNode} from 'react';
import {useInView} from 'react-intersection-observer';

const INTERSECTION_OBSERVER_PROPS = {
    rootMargin: '0px 0px 300px 0px',
};
const CAN_INTERSECT_TIMEOUT = 1000;

interface IInfiniteScrollTriggerProps {
    isLoading: boolean;
    hasItems: boolean;
    loadingNode: ReactNode;
    onLoadNeeded: () => void;
}

const InfiniteScrollTrigger: FunctionComponent<IInfiniteScrollTriggerProps> = ({
    isLoading,
    hasItems,
    loadingNode,
    onLoadNeeded,
}) => {
    const [canLoad, setCanLoad] = useState(false);
    const [ref, hasIntersected] = useInView(INTERSECTION_OBSERVER_PROPS);

    useEffect(() => {
        let timeout: NodeJS.Timeout | null = null;

        if (hasItems) {
            timeout = setTimeout(() => setCanLoad(true), CAN_INTERSECT_TIMEOUT);
        }

        return (): void => {
            if (timeout) {
                clearTimeout(timeout);
            }
        };
    }, [hasItems]);

    useEffect(() => {
        let timeout: NodeJS.Timeout | null = null;

        if (isLoading) {
            setCanLoad(false);
        } else {
            timeout = setTimeout(() => setCanLoad(true), CAN_INTERSECT_TIMEOUT);
        }

        return (): void => {
            if (timeout) {
                clearTimeout(timeout);
            }
        };
    }, [isLoading]);

    useEffect(() => {
        if (canLoad && hasIntersected && !isLoading) {
            onLoadNeeded();
        }
    }, [canLoad, hasIntersected, isLoading, onLoadNeeded]);

    return (
        <>
            {isLoading && loadingNode}
            <div ref={ref}></div>
        </>
    );
};

export default InfiniteScrollTrigger;
