import React, {createRef} from 'react';

import {IInputProps} from 'components/Input/types/InputProps';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import appData from 'utilities/appData/appData';

import {InputPresenter} from 'components/Input/controls/InputPresenter';
import InputIcon from './components/InputIcon/InputIcon';

class Input extends React.Component<IInputProps> {
    static readonly defaultProps = {
        size: 'm',
        // TODO: по типам в IInputProps нет view. Надо проверить что можно убрать
        view: 'default',
        autoComplete: 'off',
    };

    private readonly controlRef: React.RefObject<HTMLInputElement> =
        createRef();

    componentDidMount(): void {
        const {inputRef} = this.props;

        if (inputRef !== undefined) {
            // @ts-ignore хак унаследованный от команды лего
            inputRef(this.controlRef.current);
        }
    }

    private autoCompleteOffHackValue?: string =
        'off-' + appData.getByKey('uid');

    private handleChange = (): void => {
        const {onChange} = this.props;
        const target = this.controlRef.current;

        if (onChange && target) {
            onChange({target}, target.value);
        }
    };

    private handleClearClick = (): void => {
        const {onChange} = this.props;
        const target = this.controlRef.current;

        if (onChange && target) {
            onChange({target}, '');
        }
    };

    select = (): void => {
        if (this.controlRef.current) {
            this.controlRef.current.select();
        }
    };

    render(): React.ReactNode {
        const {
            onChange,
            inputRef,
            iconLeft,
            iconRight,
            disabledAutocompleteFix,
            hasClear,
            ...props
        } = this.props;
        const autoComplete =
            this.props.autoComplete === 'off' && !disabledAutocompleteFix
                ? this.autoCompleteOffHackValue
                : this.props.autoComplete;

        return (
            <InputPresenter
                {...props}
                {...prepareQaAttributes(props)}
                iconLeft={
                    <InputIcon icon={iconLeft} size={props.size} type="left" />
                }
                iconRight={
                    <InputIcon
                        icon={iconRight}
                        size={props.size}
                        hasClear={hasClear && Boolean(this.props.value)}
                        onClearClick={this.handleClearClick}
                        type="right"
                    />
                }
                controlRef={this.controlRef}
                autoComplete={autoComplete}
                onChange={this.handleChange}
                value={this.props.value}
                theme={props.theme}
            />
        );
    }
}

export default Input;
