import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {ITextinputProps} from '@yandex-lego/components/Textinput/desktop';

export interface IInputChangeEvent {
    target: HTMLInputElement;
}

export type TInputSize = 's' | 'm' | 'm-inset' | 'l';

export type TInputTheme = 'light';

export interface IInputProps
    extends Omit<ITextinputProps, 'onChange' | 'size'>,
        IWithQaAttributes {
    size?: TInputSize | undefined;
    maxLength?: number;
    disabledAutocompleteFix?: boolean;
    inputRef?: (input: HTMLInputElement | null) => void;
    onChange?: (event: IInputChangeEvent, value: string) => any;
    theme?: TInputTheme;
    hasClear?: boolean;
}
