import {RailObject} from 'react-compound-slider';

import {IInputRangeProps} from 'components/InputRange/InputRange';

/* Init Styles */
import cx from './InputRangeRail.scss';

interface IInputRangeRailProps {
    size: IInputRangeProps['size'];
    railProps: RailObject;
}

const InputRangeRail = ({railProps, size}: IInputRangeRailProps) => (
    <div
        className={cx('rail', `rail_size_${size}`)}
        {...railProps.getRailProps()}
    />
);

export default InputRangeRail;
