import React from 'react';
import {SliderItem, GetHandleProps} from 'react-compound-slider';

import {IInputRangeProps} from 'components/InputRange/InputRange';

/* Init Styles */
import cx from './InputRangeTooltip.scss';

/* Component Types */
interface IInputRangeHandleProps {
    handle: SliderItem;
    getHandleProps: GetHandleProps;
    activeHandleID: string;
    disabled?: boolean;
    isFirst: boolean;
    fixedTooltip?: boolean;
    tooltipPosition: IInputRangeProps['tooltipPosition'];
    rangeValues: IInputRangeProps['rangeValues'];
    renderHandleTooltip: IInputRangeProps['renderHandleTooltip'];
    tooltipTheme: IInputRangeProps['tooltipTheme'];
    size: IInputRangeProps['size'];
}

const InputRangeTooltip: React.FC<IInputRangeHandleProps> = ({
    handle: {value},
    size,
    tooltipTheme,
    tooltipPosition,
    rangeValues,
    isFirst,
    renderHandleTooltip,
}) => {
    if (!renderHandleTooltip) {
        return null;
    }

    const alignment = isFirst ? 'left' : 'right';

    return (
        <div
            className={cx(
                'handleTooltip',
                `handleTooltip_size_${size}`,
                `handleTooltip_position_${tooltipPosition}`,
                `handleTooltip_theme_${tooltipTheme}`,
                `handleTooltip_align_${alignment}`,
            )}
        >
            {renderHandleTooltip({value, rangeValues, alignment})}
        </div>
    );
};

export default InputRangeTooltip;
