import {Meta} from '@storybook/react/types-6-0';
import {useState} from 'react';

import {TStorybookFunctionComponent} from 'storybook/types';

import InputWithCopyButton from 'components/InputWithCopyButton/InputWithCopyButton';

export default {
    title: 'Example/InputWithCopyButton',
    component: InputWithCopyButton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isCopied, setIsCopied] = useState(false);

    return (
        <div style={{maxWidth: 400}}>
            <InputWithCopyButton
                value="some text"
                isCopied={isCopied}
                onIsCopiedChange={setIsCopied}
            />
        </div>
    );
};

Simple.parameters = {
    info: {
        title: 'Инпут с кнопкой копирования',
    },
};
