import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';

import InputWithLoader, {EInputLoadingStatus} from './InputWithLoader';

export default {
    title: 'Example/InputWithLoader',
    component: InputWithLoader,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box between="1" style={{width: 300}}>
        <InputWithLoader
            name="inputName"
            loading={EInputLoadingStatus.LOADING}
        />
        <InputWithLoader name="inputName" loading={EInputLoadingStatus.DONE} />
        <InputWithLoader
            name="inputName"
            loading={EInputLoadingStatus.DEFAULT}
        />
    </Box>
);
