import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';

import {intentsData} from './__mocks__/intentsData';
import IntentsList, {IBaseIntentItem} from './IntentsList';

export default {
    title: 'Example/IntentsList',
    component: IntentsList,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [selectedItem, setSelected] = useState<IBaseIntentItem>();

    return (
        <>
            {selectedItem && (
                <Box below="4">
                    Последний выбор: {selectedItem.text} {selectedItem.comment}
                </Box>
            )}
            <IntentsList items={intentsData} onIntentClick={setSelected} />
        </>
    );
};

export const WithCollapse: TStorybookFunctionComponent = () => {
    const {
        value: isCollapsed,
        setFalse: setCollapsed,
        setTrue: setExpanded,
    } = useBoolean(true);

    return (
        <Box between="3">
            <IntentsList
                items={intentsData}
                isCollapsed={isCollapsed}
                collapsedCount={3}
                onExpandButtonClick={setCollapsed}
                onIntentClick={noop}
            />
            <Button onClick={setExpanded} disabled={isCollapsed}>
                Reset
            </Button>
        </Box>
    );
};
