import React, {FunctionComponent, ReactNode} from 'react';
import {StickyContainer} from 'react-sticky';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import Box from 'components/Box/Box';
import {TwoColumnLayout} from 'components/Layouts/TwoColumnLayout/TwoColumnLayout';
import Breadcrumbs from './components/Breadcrumbs/Breadcrumbs';
import {CardWithDeviceLayout} from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Snippets from './components/Snippets/Snippets';
import Forms from './components/Forms/Forms';
import Cart from './components/Cart/Cart';
import CartCaption from './components/CartCaption/CartCaption';
import StickyStyledCart from './components/StickyStyledCart/StickyStyledCart';

import cx from './BookingLayout.scss';

export interface IBookingLayoutProps
    extends IWithClassName,
        IWithDeviceType,
        IWithClassName {
    leftColumn: ReactNode;
    rightColumn: ReactNode;
}

interface IStaticProps {
    Breadcrumbs: typeof Breadcrumbs;
    Snippets: typeof Snippets;
    Forms: typeof Forms;
    Card: typeof CardWithDeviceLayout;
    Cart: typeof Cart;
    CartCaption: typeof CartCaption;
}

export const BookingLayout: FunctionComponent<IBookingLayoutProps> &
    IStaticProps = ({className, deviceType, leftColumn, rightColumn}) => {
    const {isIe} = deviceType;
    const Container = isIe ? StickyContainer : React.Fragment;

    return (
        <Container>
            <TwoColumnLayout
                className={cx(
                    'root',
                    deviceMods('root', deviceType),
                    className,
                )}
                deviceType={deviceType}
                rightColumnOffset={10}
                rightColumnWidth={80}
            >
                <TwoColumnLayout.LeftColumn className={cx('leftColumn')}>
                    {leftColumn}
                </TwoColumnLayout.LeftColumn>
                <TwoColumnLayout.RightColumn>
                    {isIe ? (
                        <StickyStyledCart zIndex={3}>
                            {rightColumn}
                        </StickyStyledCart>
                    ) : (
                        <Box className={cx('cart')} between="5">
                            {rightColumn}
                        </Box>
                    )}
                </TwoColumnLayout.RightColumn>
            </TwoColumnLayout>
        </Container>
    );
};

BookingLayout.Breadcrumbs = Breadcrumbs;
BookingLayout.Snippets = Snippets;
BookingLayout.Forms = Forms;
BookingLayout.Card = CardWithDeviceLayout;
BookingLayout.Cart = Cart;
BookingLayout.CartCaption = CartCaption;

export default BookingLayout;
