import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ECardWithDeviceLayoutVariation} from 'components/CardWithDeviceLayout/types/ECardWithDeviceLayoutVariation';

import {CardWithDeviceLayout} from 'components/CardWithDeviceLayout/CardWithDeviceLayout';

interface ICartProps extends IWithClassName {}

const Cart: FunctionComponent<ICartProps> = ({className, children}) => (
    <CardWithDeviceLayout
        className={className}
        variation={ECardWithDeviceLayoutVariation.ASIDE}
        above="5"
    >
        {children}
    </CardWithDeviceLayout>
);

export default Cart;
