import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';

interface ICartCaptionProps extends IWithClassName {}

const CartCaption: FC<ICartCaptionProps> = ({children, className}) => {
    const {isMobile} = useDeviceType();

    return (
        <Box
            className={className}
            x={isMobile ? 3 : 6}
            textSize="s"
            textColor="secondary"
        >
            {children}
        </Box>
    );
};

export default CartCaption;
