import {FC, forwardRef, Ref} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';

interface IFormProps extends IWithClassName, IWithQaAttributes {
    ref?: Ref<HTMLElement>;
}

const Forms: FC<IFormProps> = forwardRef<HTMLElement, IFormProps>(
    (props, ref) => {
        const {children, className} = props;

        return (
            <Box
                between="5"
                className={className}
                ref={ref}
                {...prepareQaAttributes(props)}
            >
                {children}
            </Box>
        );
    },
);

Forms.displayName = 'Forms';

export default Forms;
