import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {EProjectName} from 'constants/common';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EFooterProject} from 'components/Footer/types';

import HappyPageLayout from './HappyPageLayout';

export default {
    title: 'Example/Layout/HappyPageLayout',
    component: HappyPageLayout,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
            .content {
                background: #E6E6E6;
                height: 100px;
            }
            `}
        </style>
        <HappyPageLayout
            project={EProjectName.TRAINS}
            footerType={EFooterProject.TRAINS}
            header={<div className="content">Header</div>}
            orderHeaderInfo={<div className="content">OrderHeaderInfo</div>}
            orderInfo={<div className="content">OrderInfo</div>}
            crossSales={<div className="content">CrossSales</div>}
        />
    </>
);

export const Loading: TStorybookFunctionComponent = () => (
    <HappyPageLayout
        project={EProjectName.TRAINS}
        footerType={EFooterProject.TRAINS}
        isLoading
    />
);
