import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/happyPage';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './HappyPageContacts.scss';

interface IHappyPageContactsProps extends IWithClassName, IWithDataQaAttribute {
    email: string;
    phone: string;
}

const HappyPageContacts: React.FC<IHappyPageContactsProps> = ({
    phone,
    email,
    className,
    ...rest
}) => {
    const deviceType = useDeviceType();

    return (
        <Flex
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
            inline={deviceType.isDesktop}
            className={cx(deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(rest)}
        >
            <Flex flexDirection="column" className={cx('email')}>
                <Text color="secondary" size="s">
                    {i18nBlock.email()}
                </Text>

                <Text
                    size={deviceType.isMobile ? 'm' : 's'}
                    {...prepareQaAttributes({current: 'email', parent: rest})}
                >
                    {email}
                </Text>
            </Flex>

            <Flex flexDirection="column">
                <Text color="secondary" size="s">
                    {i18nBlock.phone()}
                </Text>

                <Text
                    size={deviceType.isMobile ? 'm' : 's'}
                    {...prepareQaAttributes({current: 'phone', parent: rest})}
                >
                    {phone}
                </Text>
            </Flex>
        </Flex>
    );
};

export default HappyPageContacts;
