import React, {ReactNode} from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {CardWithDeviceLayout} from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Separator from 'components/Separator/Separator';
import Box from 'components/Box/Box';
import Text from 'components/Text/Text';

import HappyPageContacts from '../Contacts/HappyPageContacts';

import cx from './SingleOrderLayout.scss';

interface IMainInfoProps extends IWithDataQaAttribute {
    orderInfo: ReactNode;
    description: string;
    email: string;
    phone: string;
}

const SingleOrderLayout: React.FC<IMainInfoProps> = ({
    orderInfo,
    description,
    email,
    phone,
    ...rest
}) => {
    const deviceType = useDeviceType();

    return (
        <CardWithDeviceLayout
            className={cx(deviceMods('root', deviceType))}
            {...prepareQaAttributes(rest)}
        >
            {orderInfo}

            <Separator className={cx('orderInfoSeparator')} />

            <Box above={deviceType.isMobile ? 4 : 5}>
                <Text size="m">{description}</Text>

                <HappyPageContacts
                    email={email}
                    phone={phone}
                    className={cx('contacts')}
                    {...prepareQaAttributes(rest)}
                />
            </Box>
        </CardWithDeviceLayout>
    );
};

export default React.memo(SingleOrderLayout);
