import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {EProjectName} from 'constants/common';

import {TStorybookFunctionComponent} from 'storybook/types';

import Header from './components/Header/Header';
import Footer from './components/Footer/Footer';

import IndexLayout from './IndexLayout';

export default {
    title: 'Example/Layout/IndexLayout',
    component: IndexLayout,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <IndexLayout
        header={<Header project={EProjectName.AVIA} />}
        footer={<Footer project={EProjectName.AVIA} />}
    >
        <div style={{height: 300}}>content</div>
    </IndexLayout>
);
