import React from 'react';

import {PROJECT_FOOTER_TYPES} from 'components/Footer/constants/footerMenuItems';
import {EProjectName} from 'constants/common';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModMobile} from 'utilities/stylesUtils';

import CommonFooter from 'components/Footer/Footer';

import cx from './Footer.scss';

interface IFooterProps {
    project: EProjectName;
}

const Footer: React.FC<IFooterProps> = props => {
    const {project} = props;

    const deviceType = useDeviceType();

    const footerType = PROJECT_FOOTER_TYPES[project];

    return (
        <CommonFooter
            className={cx('root', deviceModMobile('root', deviceType))}
            project={project}
            footerType={footerType}
            isIndex
        />
    );
};

export default Footer;
